{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:22:40 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  MMObj,
  MMDIBCv,
  MMSpectr,
  MMConect,
  MMHook,
  MMDesign,
  MMDSPObj,
  MMWavOut,
  MMWave,
  MMWaveIO,
  StdCtrls, MMCstDlg;

type
  TForm1 = class(TForm)
    btnStart: TButton;
    btnStop: TButton;
    WaveFile: TMMWaveFile;
    WaveOut: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    MMConnector1: TMMConnector;
    MMSpectrum1: TMMSpectrum;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveOutStop(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure WaveOutClose(Sender: TObject);
  private
  public
    hDLL: HMODULE;
    hMem: THandle;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


{ play waves from resource in a DLL }

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   // load the DLL
   hDLL := LoadLibrary('WAVEDLL.DLL');
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormDestroy(Sender: TObject);
begin
   // unload the DLL
   FreeLibrary(hDLL);
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStartClick(Sender: TObject);
var
   lpwio : PWaveIOCB;
   hRsrc : THandle;
   pRsrc : Pointer;
   dwSize: DWORD;

begin
   // load and lock the resource
   hRsrc := FindResource(hDLL, 'TERMINATE', 'WAVE');
   hMem  := LoadResource(hDLL, hRsrc);
   if hMem = 0 then exit;

   pRsrc := LockResource(hMem);
   if pRsrc = nil then exit;

   dwSize := SizeofResource(hDLL,hRsrc);
   if dwSize = 0 then exit;

   // Build a WaveInfo from Memory }
   wioBuildFileInfoFromMem(lpwio, pRSrc,dwSize);
   if (lpwio <> nil) then
   begin
      // create a wave on the fly
      WaveFile.Wave.PWaveIOInfo := lpwio;

      // start playing
      WaveOut.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   // stop and close the device
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   // stop and close the device
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutClose(Sender: TObject);
begin
   // the device has stopped, free the file
   Wavefile.Wave.FreeWave;
end;

end.
